﻿uses GraphWPF, MathExtensions; 


// ЧЕРТИМ СПИРАЛЬ УЛАМА
procedure DrawUlamSpiral(size, cellSize: int);
begin
   Window.Clear;
   Window.Title := $' Спираль Улама {size} × {size}';
  
   var spiral := new int[size, size];
   var x := size div 2;
   var y := size div 2;
   var num := 1;
  
   // заполняем спираль:
   var dirs := Arr((0,1), (1,0), (0,-1), (-1,0));
   var dirIdx := 0;
   var steps := 1;
  
   while num <= size*size do begin
      spiral[x, y] := num;
    
      for var i := 1 to 2 do begin
          var (dx, dy) := dirs[dirIdx];
          for var j := 1 to steps do begin
              x += dx;
              y += dy;
              num += 1;
              if num <= size*size then
                 spiral[x, y] := num;
          end;
          dirIdx := (dirIdx + 1) mod 4;
      end;
      steps += 1;
   end;
  
   // спираль:
   var offsetX := (Window.Width - size * cellSize) / 2;
   var offsetY := (Window.Height - size * cellSize) / 2;
  
   for var i := 0 to size - 1 do
       for var j := 0 to size - 1 do begin
           var cellX := offsetX + j * cellSize;
           var cellY := offsetY + i * cellSize;
      
           // клетка:
           Pen.Color := Colors.LightGray;
           Brush.Color := Colors.White;
           Rectangle(cellX, cellY, cellSize, cellSize);
      
           // закрашиваем простые числа:
           if spiral[i, j].IsPrime then begin
              Brush.Color := Colors.Blue;
              FillRectangle(cellX + 1, cellY + 1, cellSize - 2, cellSize - 2);
           end;
      
          // печатаем число (для маленьких спиралей):
          if cellSize > 20 then begin
             Brush.Color := Colors.Transparent;
             Font.Size := 8;
             TextOut(cellX + 2, cellY + 2, spiral[i, j].ToString);
          end;
       end;
  
   Brush.Color := Colors.White;
   Font.Size := 12;
   TextOut(10, Window.Height - 20, 'Синие клетки - простые числа');
end;


// ОБРАБОТЧИК НАЖАТИЯ НА КЛАВИШИ
procedure KeyDown(k: Key);
begin
  case k of
    Key.D1: begin 
            Window.SetSize(600, 600); DrawUlamSpiral(21, 25); end;
    Key.D2: begin 
            Window.SetSize(600, 610); DrawUlamSpiral(31, 18); end;
    Key.D3: begin 
            Window.SetSize(650, 670); DrawUlamSpiral(41, 15); end;
    Key.D4: begin 
            Window.SetSize(700, 690); DrawUlamSpiral(51, 12); end;
    Key.Escape: Window.Close;
  end;
end;


begin
   Window.SetSize(650, 670);
   Window.CenterOnScreen;
  
   // спираль по умолчанию:
   DrawUlamSpiral(41, 15);
  
   // функция - обработчик клавиш:
   OnKeyDown := KeyDown;
  
   // инструкция:
   Writeln(' Управление:');
   Writeln(' 1 - спираль 21×21');
   Writeln(' 2 - спираль 31×31');
   Writeln(' 3 - спираль 41×41');
   Writeln(' 4 - спираль 51×51');
   Writeln(' Esc - выход');
end.